/*
 * Copyright (c) 2006 Oracle.  All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
#include <linux/percpu.h>
#include <linux/seq_file.h>
#include <linux/proc_fs.h>

#include "rds.h"
#include "ib.h"

RDS_DEFINE_PER_CPU(struct rds_ib_statistics, rds_ib_stats) 
	____cacheline_aligned;

static char *rds_ib_stat_names[] = {
	"ib_connect_raced",
	"ib_listen_closed_stale",
	"ib_tx_cq_call",
	"ib_tx_cq_event",
	"ib_tx_ring_full",
	"ib_tx_sg_mapping_failure",
	"ib_rx_cq_call",
	"ib_rx_cq_event",
	"ib_rx_refill_from_cq",
	"ib_rx_refill_from_thread",
	"ib_ack_sent",
	"ib_ack_send_failure",
	"ib_ack_send_delayed",
	"ib_ack_received",
};

unsigned int rds_ib_stats_info_copy(struct rds_info_iterator *iter,
				    unsigned int avail)
{
	struct rds_ib_statistics stats = {0, };
	unsigned long *src;
	unsigned long *sum;
	size_t i;
	int cpu;

	if (avail < ARRAY_SIZE(rds_ib_stat_names))
		goto out;

	for_each_online_cpu(cpu) {
		src = (unsigned long *)&(rds_per_cpu(rds_ib_stats, cpu));
		sum = (unsigned long *)&stats;
		for (i = 0; i < sizeof(stats) / sizeof(unsigned long); i++)
			*(sum++) += *(src++);
	}

	rds_stats_info_copy(iter, (unsigned long *)&stats, rds_ib_stat_names,
			    ARRAY_SIZE(rds_ib_stat_names));
out:
	return ARRAY_SIZE(rds_ib_stat_names);
}
